/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       layers_distribution.h
  \brief      Project wide header file that keeps track of who use what
  \author     Freescale Semiconductor
  \author     DB, r54930
  \version    1.0
  \date       20/Feb/2014
  
  * History:  20/Feb/2014- Initial Version

* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#ifndef	_LAYERS_DISTRIBUTION_H_
#define	_LAYERS_DISTRIBUTION_H_

/*******************************************************************/
/* Statically allocated layers. E.g. Can't be reused by other MC's */
/*******************************************************************/

//MC tabs  Top tabs section
#define TABS_LINE_LAYER         29      // Tile
#define TABS_CENTER_LAYER       28      // Tile
#define TABS_LEFT_LAYER         27
#define TABS_RIGHT_LAYER        26
#define TABS_VDL_LAYER          30      // Tile
#define TABS_VDL_LAYER2         31      // Tile
#define TABS_TEXT_LAYER         25

//MC tabs  Bottom info section
#define TABS_TEMPTIME_LAYER     24
#define TABS_TRIPODDO_LAYER     23
#define TABS_GEAR_LAYER         22
#define TABS_LINE_LAYER2        3		// Tile      
#define TABS_SEATBELT_LAYER     21   

#define TABS_BLOCKED0           31      // this layer is blocked for future use in Halo
#define TABS_BLOCKED1           30      // this layer is blocked for future use in Halo
#define TABS_BLOCKED2           29      // this layer is blocked for future use in Halo
#define TABS_BLOCKED3           28      // this layer is blocked for future use in Halo

/*******************************************************************/
/* Dynamically allocated layers. E.g. Can be reused by other MC's  */
/*******************************************************************/

// all stage MC's are in the middle of the screen where all the dynamic graphics is drawn
// So all stage MC layers can be reused since only 1 MC can be active at any given time

//Stage TC
#define D1_LAYER                10      // code assumes that layers are in sequence
#define D10_LAYER               11      // so if you re-assign D1 you need to re-assign D10 & D100 as well. 
#define D100_LAYER              12      
#define MODE_LAYER              13      // this is for the km/h or mph
#define TC_LINE_TOP             2       
#define TC_LINE_BOTTOM          1
#define TC_ICON                 9
#define TC_TITLE                8
#define TC_TC                   4
#define TC_ARW_UP               7
#define TC_ARW_DWN              6


// MC_BASE alias MC_PHONE
#define BASE_CENTER     10
#define BASE_LINE_TOP    9   
#define BASE_TXT_TOP     8  
#define BASE_TXT         6  

// MC_CF
#define COVERFLOW_CENTER     10
#define COVERFLOW_BARTBOT    9
#define COVERFLOW_BARGROW    8
#define COVERFLOW_PLAY       5
#define COVERFLOW_TXT        4

//MC_TUI_TEST
#define TUI_TEST_BUFFER0        0
#define TUI_TEST_BUFFER1        1

//MC_GPS
#define GPS_GRID           11
#define GPS_CENTER         10
#define GPS_ARROW           9

#define GPS_TXT           8
#define GPS_BARTOP        5
#define GPS_BARBOT        6  

//MC_DOORS
#define DOORS_BASE              10
#define DOORS_LEVEL1            9
#define DOORS_LEVEL2            8
#define DOORS_LEVEL3            7
#define DOORS_LEVEL4            6
#define DOORS_LEVEL5            5
#define DOORS_LEVEL6            4

//MC_VIDEO
#define VIDEO_MAIN           0

#endif  //_LAYERS_DISTRIBUTION_H_